package gov.va.med.mhv.common.api.util;

import com.fortify.annotations.FortifyValidate;


public class LogSanitizer {
	
	/**
	 * Removes all characters from the given <code>String</code> that are not part of an ID.
	 * The set of acceptable characters includes:  <code>A-Z a-z 0-9</code>
	 * @param idStr The ID <code>String</code> to clean.
	 * @return A <code>String</code> that cannot be used for Log Forging, or <code>null</code> if the given value was <code>null</code>.
	 */
	@FortifyValidate("return")
	public static String cleanID(String idStr) {
		if (idStr != null) {
			return idStr.replaceAll("[^A-Za-z0-9]", "");
		}
		return null;
	}
	
	/**
	 * Removes characters from the given <code>String</code> that could be used for Log Forging: </br>
	 * @param text The text <code>String</code> to clean.
	 * @return A <code>String</code> that cannot be used for Log Forging, or <code>null</code> if the given value was <code>null</code>.
	 */
	@FortifyValidate("return")
	public static String cleanText(String text) {
		if (text != null) {
			return text.replace( '\n', '_' ).replace( '\r', '_' );
		}
		return null;
	}

	
	/**
	 * Removes all characters from the given <code>String</code> that are not a number. The purpose
	 * is to remove any characters in the given <code>String</code> that could be used for Log Forging.
	 * @param numberStr The number <code>String</code> to clean.
	 * @return A <code>String</code> that cannot be used for Log Forging, or <code>null</code> if the given value was <code>null</code>.
	 */
	@FortifyValidate("return")
	public static String cleanNumber(String numberStr) {
		if (numberStr != null) {
			return numberStr.replaceAll("[^0-9]", "");
		}
		return null;
	}

}
